<?php
// save_order.php
header('Content-Type: application/json'); // PENTING: Memberitahu browser bahwa ini adalah respon JSON

// Pastikan PATH ke file database.php sudah benar relatif dari lokasi file ini.
// Karena save_order.php ada di root, ini akan mencari di folder includes/
require_once __DIR__ . '/includes/database.php';

$pdo = connectDB();

if (!$pdo) {
    // Memberi tahu JavaScript jika koneksi database gagal
    echo json_encode(['success' => false, 'message' => 'Koneksi database gagal.']);
    exit;
}

// Hanya menerima data yang dikirim dengan metode POST (dari JavaScript)
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Metode request tidak diizinkan.']);
    exit;
}

// 1. Ambil data JSON mentah dari JavaScript
$json_data = file_get_contents("php://input");
$data = json_decode($json_data, true);

// Verifikasi data dasar
if (empty($data) || !isset($data['product_id'])) {
    echo json_encode(['success' => false, 'message' => 'Data pesanan tidak lengkap atau tidak valid.']);
    exit;
}

// 2. Ekstrak data dan bersihkan
$product_id = $data['product_id'];
// Pastikan final_price adalah angka (float)
$final_price = is_numeric($data['final_price']) ? (float)$data['final_price'] : 0.00; 

// Seluruh objek data pesanan (termasuk rasa, addon, dll) disimpan sebagai string JSON
$order_details_json = json_encode($data); 

// Placeholder: Nama pelanggan (kita tidak memintanya di modal, jadi kita beri nama default)
$customer_name = 'Pelanggan Baru (Dari Web)'; 


try {
    // 3. Query INSERT ke tabel orders
    $sql = "INSERT INTO orders (product_id, customer_name, order_details, total_price, status) 
            VALUES (:pid, :cname, :details, :price, 'Pending')";
            
    $stmt = $pdo->prepare($sql);
    
    // 4. Eksekusi Query
    $stmt->execute([
        ':pid' => $product_id,
        ':cname' => $customer_name,
        ':details' => $order_details_json,
        ':price' => $final_price
    ]);

    // Ambil ID pesanan yang baru dibuat (INI YANG AKAN KITA KIRIM KE WHATSAPP)
    $last_id = $pdo->lastInsertId();

    // 5. Kirim respon sukses ke JavaScript
    echo json_encode(['success' => true, 'order_id' => $last_id]);

} catch (PDOException $e) {
    // Tangani error database
    // Hapus $e->getMessage() di produksi nyata, tapi kita biarkan untuk debugging
    echo json_encode(['success' => false, 'message' => 'Database Error: Gagal menyimpan data pesanan.']);
}
?>