<?php
session_start();
require_once __DIR__ . '/../includes/database.php';

$pdo = connectDB();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['product_id'])) {

    $id     = (int) $_POST['product_id'];
    $rasa   = $_POST['rasa'] ?? 'Original';
    $addons = $_POST['addons'] ?? '';
    $harga  = (int) $_POST['price'];

    // 🔥 AMBIL DATA PRODUK DARI DATABASE (INI KUNCINYA)
    $stmt = $pdo->prepare("SELECT nama_produk, gambar FROM products WHERE id = ?");
    $stmt->execute([$id]);
    $produk = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$produk) {
        header("Location: produk.php");
        exit;
    }

    $nama_lengkap = $produk['nama_produk'] . " (" . $rasa . ")";
    if (!empty($addons)) {
        $nama_lengkap .= " + " . $addons;
    }

    $gambar = $produk['gambar'] ?? 'default.jpg';

    $cart_key = $id . "_" . md5($rasa . $addons);

    if (!isset($_SESSION['cart'])) {
        $_SESSION['cart'] = [];
    }

    if (isset($_SESSION['cart'][$cart_key])) {
        $_SESSION['cart'][$cart_key]['jumlah'] += 1;
    } else {
        $_SESSION['cart'][$cart_key] = [
            'id_produk' => $id,
            'nama'      => $nama_lengkap,
            'harga'     => $harga,
            'jumlah'    => 1,
            'gambar'    => $gambar
        ];
    }

    header("Location: keranjang.php");
    exit;
}
