<?php
session_start();
require_once __DIR__.'/../includes/database.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_SESSION['checkout'])) {
    $_SESSION['checkout'] = $_POST;
}

if (!isset($_SESSION['checkout'])) {
    header("Location: keranjang.php");
    exit;
}

$data = $_SESSION['checkout'];

if (isset($_POST['bayar'])) {
    $pdo = connectDB();

    $stmt = $pdo->prepare("
        INSERT INTO orders
        (nama_pelanggan, no_wa, total, status, alamat_pengiriman, tanggal_ambil)
        VALUES (?, ?, ?, 'pending', ?, ?)
    ");
    $stmt->execute([
        $data['nama'],
        $data['no_wa'],
        $data['total'],
        $data['alamat'],
        $data['tanggal_ambil']
    ]);

    unset($_SESSION['cart']);

    $msg = "Halo LimcyCake 👋\n"
        ."Nama: {$data['nama']}\n"
        ."No WA: {$data['no_wa']}\n"
        ."Tanggal Ambil: {$data['tanggal_ambil']}\n"
        ."Total: Rp ".number_format($data['total'],0,',','.')."\n\n"
        ."Saya sudah bayar via QRIS 🤍";

    header("Location: https://wa.me/6281528957059?text=".urlencode($msg));
    exit;
}
?>

<?php include __DIR__.'/../includes/header.php'; ?>

<style>
.box{max-width:500px;margin:4rem auto;background:#fefbf6;padding:2rem;border-radius:16px;border:1px solid #e8dfca;text-align:center}
.btn{background:#8b7355;color:#fff;padding:1rem;border-radius:12px;font-weight:bold;cursor:pointer;margin-top:1.5rem;border:none}
</style>

<div class="box">
    <h2>Scan QRIS</h2>
    <img src="/limcycake_balikpapan/assets/images/produk/qris.jpg" alt="QRIS" style="max-width:250px;">

    <form method="post">
        <button class="btn" name="bayar">Saya Sudah Membayar</button>
    </form>
</div>

<?php include __DIR__.'/../includes/footer.php'; ?>
