<?php
session_start();
if (empty($_SESSION['cart'])) {
    header("Location: keranjang.php");
    exit;
}

$subtotal = 0;
foreach ($_SESSION['cart'] as $item) {
    $subtotal += $item['harga'] * $item['jumlah'];
}
include __DIR__ . '/../includes/header.php';
?>

<style>
.checkout-container{max-width:1100px;margin:2.5rem auto;display:grid;grid-template-columns:2fr 1fr;gap:2rem;font-family:Georgia,serif}
.card{background:#fefbf6;border:1px solid #e8dfca;border-radius:16px;padding:2rem}
h2{color:#8b7355}
label{margin-top:1rem;display:block}
input,textarea{width:100%;padding:.75rem;border-radius:10px;border:1px solid #d8ccb6}
.max-order{color:#c0392b;font-weight:bold;font-size:.85rem;margin-top:.3rem}
.radio-box{border:1px solid #e0d5bf;border-radius:12px;padding:1rem;margin-top:.8rem}
.summary-item{display:flex;justify-content:space-between;margin-bottom:.6rem}
.total{font-size:1.2rem;font-weight:bold;color:#8b7355}
.btn{margin-top:1.5rem;background:#8b7355;color:#fff;padding:1rem;border-radius:12px;text-align:center;font-weight:bold;cursor:pointer}
</style>

<div class="checkout-container">

<div class="card">
<h2>Data Pemesan</h2>

<label>Nama</label>
<input id="nama">

<label>No WhatsApp</label>
<input id="wa">

<label>Tanggal Produksi</label>
<input type="date" id="tanggal">
<div class="max-order">⚠️ MAX ORDER H-2</div>

<label>Catatan Pesanan</label>
<textarea id="catatan"></textarea>

<h2 style="margin-top:2rem">Metode Pengambilan</h2>

<label class="radio-box">
<input type="radio" name="ambil" value="Ambil di Toko" checked onchange="toggleOngkir(false)"> Ambil di Toko
</label>

<label class="radio-box">
<input type="radio" name="ambil" value="Diantar" onchange="toggleOngkir(true)"> Diantar
</label>

<div id="ongkirBox" style="display:none">
<label class="radio-box">
<input type="radio" name="ongkir" value="12000" checked> Balikpapan Tengah – Rp 12.000
</label>
<label class="radio-box">
<input type="radio" name="ongkir" value="17000"> Luar Balikpapan Tengah – Rp 17.000
</label>
</div>
</div>

<div class="card">
<h2>Ringkasan</h2>

<?php foreach($_SESSION['cart'] as $item): ?>
<div class="summary-item">
<span><?= $item['nama'] ?> (<?= $item['jumlah'] ?>x)</span>
<span>Rp <?= number_format($item['harga']*$item['jumlah'],0,',','.') ?></span>
</div>
<?php endforeach ?>

<hr>

<div class="summary-item">
<span>Subtotal</span>
<span id="subtotal">Rp <?= number_format($subtotal,0,',','.') ?></span>
</div>

<div class="summary-item">
<span>Ongkir</span>
<span id="ongkirText">Rp 0</span>
</div>

<hr>

<div class="summary-item total">
<span>Total</span>
<span id="totalText">Rp <?= number_format($subtotal,0,',','.') ?></span>
</div>

<form method="POST" action="pembayaran.php">
    <input type="hidden" name="nama" id="f_nama">
    <input type="hidden" name="no_wa" id="f_wa">
    <input type="hidden" name="tanggal_ambil" id="f_tanggal">
    <input type="hidden" name="catatan" id="f_catatan">
    <input type="hidden" name="total" id="f_total">
    <input type="hidden" name="alamat" value="-">

    <button type="submit" class="btn" onclick="isiForm()">Lanjut ke Pembayaran</button>
</form>

</div>
</div>

<script>
const subtotal = <?= $subtotal ?>;
const totalText = document.getElementById('totalText');
const ongkirText = document.getElementById('ongkirText');

function toggleOngkir(show){
    document.getElementById('ongkirBox').style.display = show?'block':'none';
    updateTotal();
}

document.querySelectorAll('input[name="ongkir"]').forEach(r=>r.onchange=updateTotal);

function updateTotal(){
    const ongkir = document.querySelector('input[name="ongkir"]:checked')?.value || 0;
    ongkirText.innerText = 'Rp '+parseInt(ongkir).toLocaleString('id-ID');
    totalText.innerText = 'Rp '+(subtotal+parseInt(ongkir)).toLocaleString('id-ID');
}

function isiForm(){
    f_nama.value = nama.value;
    f_wa.value = wa.value;
    f_tanggal.value = tanggal.value;
    f_catatan.value = catatan.value;
    f_total.value = totalText.innerText.replace(/[^\d]/g,'');
}
</script>

<?php include __DIR__ . '/../includes/footer.php'; ?>
