<?php
session_start();
include 'includes/header.php';

// Jika sudah login sebagai admin, redirect ke admin panel
if (isset($_SESSION['user_id']) && $_SESSION['user_role'] == 'admin') {
    header("Location: admin/index.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'];
    $password = $_POST['password'];
    
    $pdo = connectDB();
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ? AND role = 'admin'"); // Hanya admin
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_name'] = $user['full_name'];
        $_SESSION['user_role'] = $user['role'];
        $_SESSION['user_email'] = $user['email'];
        
        header("Location: admin/index.php");
        exit();
    } else {
        $error = "Email atau password salah! Hanya admin yang bisa login.";
    }
}
?>

<div class="container">
    <div style="max-width: 400px; margin: 50px auto; padding: 2rem; background: #f8f4e9; border-radius: 10px; border: 1px solid #e8dfca;">
        <h2 style="text-align: center; color: #8b7355; margin-bottom: 1.5rem;">
            <i class="fas fa-crown"></i> Login Admin
        </h2>
        
        <?php if (isset($error)): ?>
            <div style="background: #ffeaa7; color: #e17055; padding: 1rem; border-radius: 5px; margin-bottom: 1rem; border: 1px solid #fdcb6e;">
                <?php echo $error; ?>
            </div>
        <?php endif; ?>
        
        <form method="POST" action="">
            <div style="margin-bottom: 1rem;">
                <label style="display: block; margin-bottom: 0.5rem; color: #8b7355; font-weight: 600;">Email Admin</label>
                <input type="email" name="email" style="width: 100%; padding: 0.8rem; border: 2px solid #d4c9b8; border-radius: 5px; background: #fefbf6; color: #5c4b37;" required>
            </div>
            
            <div style="margin-bottom: 1.5rem;">
                <label style="display: block; margin-bottom: 0.5rem; color: #8b7355; font-weight: 600;">Password</label>
                <input type="password" name="password" style="width: 100%; padding: 0.8rem; border: 2px solid #d4c9b8; border-radius: 5px; background: #fefbf6; color: #5c4b37;" required>
            </div>
            
            <button type="submit" class="btn btn-primary" style="width: 100%;">
                <i class="fas fa-sign-in-alt"></i> Login sebagai Admin
            </button>
        </form>
        
        <div style="text-align: center; margin-top: 1.5rem; padding-top: 1rem; border-top: 1px solid #e8dfca;">
            <small style="color: #7a6852;">
                Hanya untuk administrator website.<br>
                Customer tidak perlu login untuk berbelanja.
            </small>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>