<?php
session_start();
require_once 'includes/database.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['product_id'])) {
    $pdo = connectDB();
    $product_id = $_POST['product_id'];
    $quantity = $_POST['quantity'] ?? 1;

    // 1. Buat session_id keranjang kalau belum ada
    if (!isset($_SESSION['cart_session'])) {
        $_SESSION['cart_session'] = session_id();
    }
    $session_id = $_SESSION['cart_session'];

    // 2. Cek apakah produk sudah ada di keranjang
    $stmt = $pdo->prepare("SELECT id, quantity FROM cart WHERE session_id = ? AND product_id = ?");
    $stmt->execute([$session_id, $product_id]);
    $existingCart = $stmt->fetch();

    if ($existingCart) {
        // Kalau sudah ada, tambah jumlahnya
        $stmt = $pdo->prepare("UPDATE cart SET quantity = quantity + ? WHERE id = ?");
        $stmt->execute([$quantity, $existingCart['id']]);
    } else {
        // Kalau belum ada, insert baru
        $stmt = $pdo->prepare("INSERT INTO cart (session_id, product_id, quantity) VALUES (?, ?, ?)");
        $stmt->execute([$session_id, $product_id, $quantity]);
    }

    // 3. LANGSUNG ARAHKAN KE HALAMAN KERANJANG
    header("Location: cart.php"); 
    exit();
} else {
    // Kalau orang iseng buka file ini langsung, balikin ke index
    header("Location: index.php");
    exit();
}