<?php
session_start();

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

require_once __DIR__ . '/../includes/database.php';
$pdo = connectDB();

$products = [];
if ($pdo) {
    $stmt = $pdo->query("SELECT id, nama_produk, harga, stok FROM products ORDER BY id ASC");
    $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Kelola Produk - Admin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <style>
        body {
            margin: 0;
            min-height: 100vh;
            font-family: 'Poppins', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            background:
                linear-gradient(
                    rgba(248, 244, 233, 0.9),
                    rgba(248, 244, 233, 0.9)
                ),
                url('/limcycake_balikpapan/assets/images/bgadmin.jpeg');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
        }

        .admin-box {
            width: 95%;
            max-width: 1000px;
            background: white;
            padding: 2.5rem;
            border-radius: 18px;
            border: 2px solid #e8dfca;
            box-shadow: 0 20px 40px rgba(0,0,0,0.15);
        }

        h2 {
            margin-top: 0;
            color: #a9926d;
            text-align: center;
        }

        .top-bar {
            display: flex;
            justify-content: space-between;
            margin-bottom: 1.5rem;
        }

        .top-bar a {
            padding: 0.6rem 1.4rem;
            background: #a9926d;
            color: white;
            text-decoration: none;
            border-radius: 20px;
            font-size: 0.85rem;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 1rem;
        }

        th, td {
            padding: 0.8rem;
            text-align: center;
            font-size: 0.85rem;
            border-bottom: 1px solid #eee;
        }

        th {
            background: #f2ede1;
            color: #a9926d;
        }

        tr:last-child td {
            border-bottom: none;
        }

        .aksi a {
            display: inline-block;
            margin: 0 0.2rem;
            padding: 0.35rem 0.9rem;
            font-size: 0.75rem;
            color: white;
            border-radius: 14px;
            text-decoration: none;
        }

        .edit {
            background: #7c9a6d;
        }

        .hapus {
            background: #c96b6b;
        }

        .footer-link {
            margin-top: 1.5rem;
            text-align: center;
        }

        .footer-link a {
            color: #a9926d;
            font-size: 0.85rem;
            text-decoration: none;
        }
    </style>
</head>
<body>

<div class="admin-box">
    <h2>Kelola Produk</h2>

    <div class="top-bar">
        <a href="dashboard_admin.php">Dashboard</a>
        <a href="tambah_produk_admin.php">Tambah Produk</a>
    </div>

    <?php if (count($products) === 0): ?>
        <p style="text-align:center;">Belum ada produk.</p>
    <?php else: ?>
        <table>
            <tr>
                <th>ID</th>
                <th>Nama Produk</th>
                <th>Harga</th>
                <th>Stok</th>
                <th>Aksi</th>
            </tr>

            <?php foreach ($products as $p): ?>
            <tr>
                <td><?= $p['id'] ?></td>
                <td><?= htmlspecialchars($p['nama_produk']) ?></td>
                <td>Rp <?= number_format($p['harga'],0,',','.') ?></td>
                <td><?= $p['stok'] ?></td>
                <td class="aksi">
                    <a class="edit" href="edit_produk_admin.php?id=<?= $p['id'] ?>">Edit</a>
                    <a class="hapus"
                       href="hapus_produk_admin.php?id=<?= $p['id'] ?>"
                       onclick="return confirm('Yakin hapus produk?')">
                       Hapus
                    </a>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>

    <div class="footer-link">
        <a href="logout.php">Logout</a>
    </div>
</div>

</body>
</html>
