<?php
session_start();

// Cek apakah user sudah login dan role admin
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] != 'admin') {
    header("Location: login.php");
    exit();
}

include __DIR__ . '/../includes/header.php';
?>

<div class="container">
    <!-- Header Admin -->
    <div style="background: linear-gradient(135deg, #8b7355, #a9926d); color: white; padding: 2rem; border-radius: 10px; margin: 2rem 0;">
        <h1><i class="fas fa-crown"></i> Panel Admin LimcyCake</h1>
        <p>Selamat datang, <?php echo $_SESSION['user_name']; ?>! - Kelola toko kue Anda dengan mudah</p>
    </div>

    <!-- Quick Stats -->
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem; margin: 2rem 0;">
        <div style="background: #f8f4e9; padding: 1.5rem; border-radius: 10px; border: 1px solid #e8dfca; text-align: center;">
            <i class="fas fa-shopping-cart" style="color: #a9926d; font-size: 2rem; margin-bottom: 1rem;"></i>
            <h3 style="color: #8b7355;">Total Pesanan</h3>
            <p style="color: #7a6852; font-size: 1.5rem; font-weight: bold; margin: 0.5rem 0;">15</p>
            <small style="color: #a9926d;">+2 hari ini</small>
        </div>

        <div style="background: #f8f4e9; padding: 1.5rem; border-radius: 10px; border: 1px solid #e8dfca; text-align: center;">
            <i class="fas fa-money-bill-wave" style="color: #a9926d; font-size: 2rem; margin-bottom: 1rem;"></i>
            <h3 style="color: #8b7355;">Pendapatan</h3>
            <p style="color: #7a6852; font-size: 1.5rem; font-weight: bold; margin: 0.5rem 0;">Rp 3.5jt</p>
            <small style="color: #a9926d;">Bulan ini</small>
        </div>

        <div style="background: #f8f4e9; padding: 1.5rem; border-radius: 10px; border: 1px solid #e8dfca; text-align: center;">
            <i class="fas fa-users" style="color: #a9926d; font-size: 2rem; margin-bottom: 1rem;"></i>
            <h3 style="color: #8b7355;">Pelanggan</h3>
            <p style="color: #7a6852; font-size: 1.5rem; font-weight: bold; margin: 0.5rem 0;">42</p>
            <small style="color: #a9926d;">Aktif</small>
        </div>

        <div style="background: #f8f4e9; padding: 1.5rem; border-radius: 10px; border: 1px solid #e8dfca; text-align: center;">
            <i class="fas fa-cube" style="color: #a9926d; font-size: 2rem; margin-bottom: 1rem;"></i>
            <h3 style="color: #8b7355;">Produk</h3>
            <p style="color: #7a6852; font-size: 1.5rem; font-weight: bold; margin: 0.5rem 0;">8</p>
            <small style="color: #a9926d;">Tersedia</small>
        </div>
    </div>

    <!-- Admin Menu Grid -->
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 1.5rem; margin: 2rem 0;">
        <!-- Kelola Produk -->
        <div style="background: #f8f4e9; padding: 1.5rem; border-radius: 10px; border: 1px solid #e8dfca;">
            <h3 style="color: #8b7355; margin-bottom: 1rem;">
                <i class="fas fa-box"></i> Kelola Produk
            </h3>
            <p style="color: #7a6852; margin-bottom: 1rem;">Tambah, edit, atau hapus produk kue</p>
            <div style="display: flex; gap: 0.5rem; flex-wrap: wrap;">
                <a href="admin_products.php" class="btn btn-primary">Lihat Semua Produk</a>
                <a href="tambah_produk.php" class="btn btn-outline">Tambah Produk Baru</a>
            </div>
        </div>

        <!-- Kelola Pesanan -->
        <div style="background: #f8f4e9; padding: 1.5rem; border-radius: 10px; border: 1px solid #e8dfca;">
            <h3 style="color: #8b7355; margin-bottom: 1rem;">
                <i class="fas fa-clipboard-list"></i> Kelola Pesanan
            </h3>
            <p style="color: #7a6852; margin-bottom: 1rem;">Lihat dan kelola pesanan customer</p>
            <div style="display: flex; gap: 0.5rem; flex-wrap: wrap;">
                <a href="admin_orders.php" class="btn btn-primary">Pesanan Baru (3)</a>
                <a href="pesanan.php" class="btn btn-outline">Semua Pesanan</a>
            </div>
        </div>

        <!-- Quick Actions -->
        <div style="background: #f8f4e9; padding: 1.5rem; border-radius: 10px; border: 1px solid #e8dfca;">
            <h3 style="color: #8b7355; margin-bottom: 1rem;">
                <i class="fas fa-bolt"></i> Quick Actions
            </h3>
            <p style="color: #7a6852; margin-bottom: 1rem;">Akses cepat ke fitur penting</p>
            <div style="display: flex; gap: 0.5rem; flex-wrap: wrap;">
                <a href="tambah_produk.php" class="btn btn-primary">Tambah Produk</a>
                <a href="admin_orders.php" class="btn btn-outline">Lihat Pesanan</a>
                <a href="admin.php" class="btn btn-outline">Admin Settings</a>
            </div>
        </div>

        <!-- Account Management -->
        <div style="background: #f8f4e9; padding: 1.5rem; border-radius: 10px; border: 1px solid #e8dfca;">
            <h3 style="color: #8b7355; margin-bottom: 1rem;">
                <i class="fas fa-user-cog"></i> Akun
            </h3>
            <p style="color: #7a6852; margin-bottom: 1rem;">Kelola akun admin dan pengaturan</p>
            <div style="display: flex; gap: 0.5rem; flex-wrap: wrap;">
                <a href="admin.php" class="btn btn-primary">Pengaturan</a>
                <a href="logout.php" class="btn btn-outline">Logout (<?php echo $_SESSION['user_name']; ?>)</a>
            </div>
        </div>
    </div>

    <!-- Recent Activity -->
    <div style="background: #f8f4e9; padding: 1.5rem; border-radius: 10px; border: 1px solid #e8dfca; margin: 2rem 0;">
        <h3 style="color: #8b7355; margin-bottom: 1rem;">
            <i class="fas fa-history"></i> Aktivitas Terbaru
        </h3>
        <div style="color: #7a6852;">
            <div style="display: flex; justify-content: space-between; padding: 0.5rem 0; border-bottom: 1px solid #e8dfca;">
                <span>Pesanan baru #0012 dari Budi</span>
                <small>10 menit lalu</small>
            </div>
            <div style="display: flex; justify-content: space-between; padding: 0.5rem 0; border-bottom: 1px solid #e8dfca;">
                <span>Produk "Red Velvet Cake" diedit</span>
                <small>1 jam lalu</small>
            </div>
            <div style="display: flex; justify-content: space-between; padding: 0.5rem 0;">
                <span>Pembayaran #0011 dikonfirmasi</span>
                <small>2 jam lalu</small>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>