<?php
$bodyClass = 'inner-page';
include __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/database.php';
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/functions.php';

ini_set('display_errors', 0); 
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

$pdo = connectDB();
$products = [];
if ($pdo) {
    try {
        $stmt = $pdo->query("SELECT id, nama_produk, harga, gambar, deskripsi FROM products WHERE stok > 0 ORDER BY id ASC");
        $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        $pdo = null;
    }
}

$product_data_complete = [
    1 => ['variants' => [['rasa' => 'Vanila', 'harga_tambahan' => 0],['rasa' => 'Coklat', 'harga_tambahan' => 0],['rasa' => 'Blackforest', 'harga_tambahan' => 2000]], 'addons' => [], 'deskripsi_bersih' => 'Bento cake mini ukuran 10x10cm dengan dekorasi polosan krim dan tulisan custom.'],
    2 => ['variants' => [['rasa' => 'Vanila', 'harga_tambahan' => 0],['rasa' => 'Coklat', 'harga_tambahan' => 0],['rasa' => 'Blackforest', 'harga_tambahan' => 5000]], 'addons' => [], 'deskripsi_bersih' => 'Bento cake dengan desain simple dan tulisan custom.'],
    3 => ['variants' => [['rasa' => 'Vanila', 'harga_tambahan' => 0],['rasa' => 'Coklat', 'harga_tambahan' => 0],['rasa' => 'Blackforest', 'harga_tambahan' => 5000]], 'addons' => [], 'deskripsi_bersih' => 'Bento cake dengan tambahan dekorasi karakter lucu.'],
    4 => ['variants' => [['rasa' => 'Vanila', 'harga_tambahan' => 0],['rasa' => 'Coklat', 'harga_tambahan' => 0],['rasa' => 'Blackforest', 'harga_tambahan' => 5000]], 'addons' => [['nama' => 'Design tertentu', 'harga' => 5000],['nama' => 'Karakter', 'harga' => 10000],['nama' => 'Tulisan di board', 'harga' => 5000]], 'deskripsi_bersih' => 'Paket spesial dua bento cake mini.'],
    5 => ['variants' => [['rasa' => 'Vanila', 'harga_tambahan' => 0],['rasa' => 'Coklat', 'harga_tambahan' => 0],['rasa' => 'Blackforest', 'harga_tambahan' => 5000]], 'addons' => [['nama' => 'Karakter', 'harga' => 10000],['nama' => 'Design Nuansa Flower', 'harga' => 10000],['nama' => 'Design Nuansa Vintage', 'harga' => 10000]], 'deskripsi_bersih' => 'Bento cake & Two CupCake tersedia rasa Vanila, Coklat, dan Blackforest.'],
    6 => ['variants' => [['rasa' => 'Vanila', 'harga_tambahan' => 0],['rasa' => 'Coklat', 'harga_tambahan' => 0],['rasa' => 'Blackforest', 'harga_tambahan' => 5000]], 'addons' => [['nama' => 'Design Nuansa Vintage', 'harga' => 10000]], 'deskripsi_bersih' => 'Kue kecil berdiameter 15 cm dengan tinggi 5 cm.'],
];

foreach ($products as $key => $product) {
    $id = $product['id'];
    $filename = strtolower($product['gambar']);
    if (strpos($filename, 'bentocakedantwocupcake') !== false) $id = 5;
    if (strpos($filename, 'pocketsize') !== false) $id = 6;
    
    $detail = $product_data_complete[$id] ?? ['variants' => [], 'addons' => [], 'deskripsi_bersih' => ''];
    $products[$key]['variants'] = $detail['variants'];
    $products[$key]['addons'] = $detail['addons'];
    $products[$key]['deskripsi_modal'] = $detail['deskripsi_bersih']; 
    
    if (strpos($filename, 'minimalist') !== false) $products[$key]['nama_produk_tampilan'] = 'Minimalis Bento Cake';
    elseif (strpos($filename, 'simple') !== false) $products[$key]['nama_produk_tampilan'] = 'Simple Bento Cake';
    elseif (strpos($filename, 'character') !== false) $products[$key]['nama_produk_tampilan'] = 'Character Bento Cake';
    elseif (strpos($filename, 'multiset') !== false) $products[$key]['nama_produk_tampilan'] = 'Multiset Cake';
    elseif (strpos($filename, 'bentocakedantwocupcake') !== false) $products[$key]['nama_produk_tampilan'] = 'Bento Cake And Two CupCake';
    elseif (strpos($filename, 'pocketsize') !== false) $products[$key]['nama_produk_tampilan'] = 'Pocket Size';
    else $products[$key]['nama_produk_tampilan'] = $product['nama_produk'];
}
?>

<div class="container">
    <div class="produk-header">
    <h1>Koleksi Bento Cake Kami</h1>
    <p>Pilih berbagai varian bento cake premium</p>
</div>


    <div class="products-grid">
        <?php if (count($products) > 0): ?>
            <?php foreach ($products as $product): ?>
                <div class="product-card shadow-soft">
                    <div class="product-image-wrapper">
                    <img src="<?php echo BASE_URL; ?>/assets/images/<?php echo htmlspecialchars($product['gambar']); ?>" class="product-image-actual">
                    </div>
                    <div class="product-info">
                        <span class="product-category">Bento Cake</span> 
                        <h3><?php echo htmlspecialchars($product['nama_produk_tampilan']); ?></h3>
                        <div class="price-section">
                            <span class="price-label">Mulai Dari:</span>
                            <span class="main-price"><?php echo formatRupiah($product['harga']); ?></span>
                        </div>
                        <div class="product-actions">
                            <button class="btn btn-outline" onclick="showDetail(<?php echo $product['id']; ?>)">Detail</button>
                            <button class="btn btn-primary" onclick="showDetail(<?php echo $product['id']; ?>)">Pesan Sekarang</button>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>

<div id="productModal" class="modal">
    <div class="modal-content">
        <span class="close" onclick="closeModal()">&times;</span>
        <div id="modalBody"></div>
    </div>
</div>

<style>
.products-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 2rem; margin: 2rem 0; }
.product-card { background: #f8f4e9; border-radius: 15px; overflow: hidden; border: 2px solid #e8dfca; transition: 0.3s; }
.product-image-wrapper { width: 100%; height: 250px; overflow: hidden; }
.product-image-actual { width: 100%; height: 100%; object-fit: cover; }
.product-info { padding: 1.5rem; }
.main-price { color: #a9926d; font-weight: 700; font-size: 1.4rem; }
.product-actions { display: flex; gap: 0.8rem; margin-top: 1.2rem; }
.btn { flex: 1; padding: 0.8rem; cursor: pointer; border-radius: 5px; border: none; }
.btn-primary { background: #a9926d; color: white; }
.btn-outline { background: transparent; border: 1px solid #a9926d; color: #a9926d; }
.modal { display: none; position: fixed; z-index: 1000; left: 0; top: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); }
.modal-content { background: #fff; margin: 5% auto; padding: 2rem; width: 90%; max-width: 500px; border-radius: 10px; position: relative; }
.close { position: absolute; right: 1rem; top: 0.5rem; font-size: 2rem; cursor: pointer; }
.variant-selection, .addon-selection { display: flex; flex-wrap: wrap; gap: 0.5rem; margin: 1rem 0; }
.variant-button, .addon-button { background: #eee; padding: 0.5rem 1rem; border-radius: 5px; cursor: pointer; display: block; border: 1px solid #ccc; }
input[type="radio"]:checked + .variant-button, input[type="checkbox"]:checked + .addon-button { background: #a9926d; color: white; }
input[type="radio"], input[type="checkbox"] { display: none; }
</style>

<script>
const allProducts = <?php echo json_encode($products); ?>; 

function formatRupiahJS(angka) {
    return "Rp " + new Intl.NumberFormat('id-ID').format(Math.round(angka));
}

function updateModalPrice() {
    let basePrice = parseFloat(document.getElementById('modalBasePrice').value);
    let total = basePrice;
    const selectedVariant = document.querySelector(`input[name="product-rasa"]:checked`);
    if (selectedVariant) total += parseFloat(selectedVariant.value);
    const selectedAddons = document.querySelectorAll(`input[name="product-addon"]:checked`);
    selectedAddons.forEach(cb => total += parseFloat(cb.value));
    document.getElementById('modalPriceDisplay').innerText = formatRupiahJS(total);
}

function showDetail(productId) {
    const product = allProducts.find(p => p.id == productId);
    if (!product) return;

    let variantsHtml = product.variants.map((v, i) => `
        <input type="radio" id="r-${i}" name="product-rasa" value="${v.harga_tambahan}" data-rasa="${v.rasa}" onchange="updateModalPrice()" ${i===0?'checked':''}>
        <label for="r-${i}" class="variant-button">${v.rasa} ${v.harga_tambahan > 0 ? '(+'+v.harga_tambahan+')' : ''}</label>
    `).join('');

    let addonsHtml = product.addons.map((a, i) => `
        <input type="checkbox" id="a-${i}" name="product-addon" value="${a.harga}" data-addon="${a.nama}" onchange="updateModalPrice()">
        <label for="a-${i}" class="addon-button">${a.nama} (+${a.harga})</label>
    `).join('');

    document.getElementById('modalBody').innerHTML = `
        <input type="hidden" id="modalBasePrice" value="${product.harga}">
        <h2>${product.nama_produk_tampilan}</h2>
        <h3 id="modalPriceDisplay" style="color: #a9926d;">${formatRupiahJS(product.harga)}</h3>
        <p>${product.deskripsi_modal}</p>
        <h4>Pilih Rasa:</h4><div class="variant-selection">${variantsHtml}</div>
        <h4>Tambahan:</h4><div class="addon-selection">${addonsHtml}</div>
        <button class="btn btn-primary" style="width:100%" onclick="addToCart(${product.id})">TAMBAHKAN KE KERANJANG</button>
    `;
    updateModalPrice();
    document.getElementById('productModal').style.display = 'block';
}

function closeModal() { document.getElementById('productModal').style.display = 'none'; }


function addToCart(productId) {
    const product = allProducts.find(p => p.id == productId);
    if (!product) return;

    const rasa = document.querySelector('input[name="product-rasa"]:checked')?.dataset.rasa || 'Original';
    const addons = Array.from(document.querySelectorAll('input[name="product-addon"]:checked'))
        .map(cb => cb.dataset.addon)
        .join(', ');
    const price = document.getElementById('modalPriceDisplay').innerText.replace(/[^0-9]/g, '');

    const form = document.createElement('form');
    form.method = 'POST';
    form.action = 'proses_keranjang.php';

    const data = {
        product_id: productId,
        rasa: rasa,
        addons: addons,
        price: price,
        gambar: product.gambar   // 🔥 INI YANG BIKIN FOTO MUNCUL
    };

    for (const key in data) {
        const input = document.createElement('input');
        input.type = 'hidden';
        input.name = key;
        input.value = data[key];
        form.appendChild(input);
    }

    document.body.appendChild(form);
    form.submit();
}

</script>

<?php include __DIR__ . '/../includes/footer.php'; ?>