<?php
$bodyClass = 'inner-page';
include __DIR__ . '/../includes/header.php';
?>

<div class="container">
    <div class="contact-header">
    <h1 class="contact-title">Hubungi Kami</h1>
    <p>Tim customer service kami siap membantu Anda 7 hari seminggu</p>
</div>

    <!-- Quick Contact Cards -->
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem; margin: 2rem 0;">
        <div style="background: #f8f4e9; padding: 1.5rem; border-radius: 10px; border: 1px solid #e8dfca; text-align: center;">
            <i class="fas fa-phone" style="color: #a9926d; font-size: 2rem; margin-bottom: 1rem;"></i>
            <h3 style="color: #8b7355; margin-bottom: 0.5rem;">Telepon</h3>
            <p style="color: #7a6852; margin: 0;">0815-2895-7059</p>
            <small style="color: #a9926d;">Setiap hari 11:00 - 18:00 WITA</small>
        </div>

        <div style="background: #f8f4e9; padding: 1.5rem; border-radius: 10px; border: 1px solid #e8dfca; text-align: center;">
            <i class="fab fa-whatsapp" style="color: #a9926d; font-size: 2rem; margin-bottom: 1rem;"></i>
            <h3 style="color: #8b7355; margin-bottom: 0.5rem;">WhatsApp</h3>
            <p style="color: #7a6852; margin: 0;">0815-2895-7059</p>
            <small style="color: #a9926d;">Fast Response</small>
        </div>

        <div style="background: #f8f4e9; padding: 1.5rem; border-radius: 10px; border: 1px solid #e8dfca; text-align: center;">
    <i class="fab fa-instagram" style="color: #a9926d; font-size: 2rem; margin-bottom: 1rem;"></i>
    <h3 style="color: #8b7355; margin-bottom: 0.5rem;">Instagram</h3>
    <p style="color: #7a6852; margin: 0;">@limcycake.bpn</p>
    <small style="color: #a9926d;">Fast Response</small>
</div>


        <div style="background: #f8f4e9; padding: 1.5rem; border-radius: 10px; border: 1px solid #e8dfca; text-align: center;">
            <i class="fas fa-store" style="color: #a9926d; font-size: 2rem; margin-bottom: 1rem;"></i>
            <h3 style="color: #8b7355; margin-bottom: 0.5rem;">Toko</h3>
            <p style="color: #7a6852; margin: 0;">Jl. Mayjend Sutoyo, Gunung Malang</p>
            <small style="color: #a9926d;">Balikpapan</small>
        </div>
    </div>

    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 3rem; margin-top: 2rem;">
        <!-- FAQ & Quick Questions -->
        <div>
            <h2 style="color: #8b7355; margin-bottom: 1.5rem;">Pertanyaan Umum</h2>
            
            <!-- FAQ Accordion -->
            <div style="background: #f8f4e9; padding: 1.5rem; border-radius: 10px; border: 1px solid #e8dfca;">
                <div class="faq-item" style="margin-bottom: 1rem; border-bottom: 1px solid #e8dfca; padding-bottom: 1rem;">
                    <div style="display: flex; justify-content: between; align-items: center; cursor: pointer;" onclick="toggleFAQ(1)">
                        <h4 style="color: #8b7355; margin: 0;">🕐 Berapa lama waktu pemesanan?</h4>
                        <i class="fas fa-chevron-down" id="icon-1"></i>
                    </div>
                    <p id="answer-1" style="color: #7a6852; margin: 0.5rem 0 0 0; display: none;">
                        Pemesanan dilakukan maksimal H-2 sebelum tanggal pengambilan. Referensi atau inspirasi desain cake dapat dikirimkan melalui WhatsApp.
                    </p>
                </div>

                <div class="faq-item" style="margin-bottom: 1rem; border-bottom: 1px solid #e8dfca; padding-bottom: 1rem;">
                    <div style="display: flex; justify-content: between; align-items: center; cursor: pointer;" onclick="toggleFAQ(2)">
                        <h4 style="color: #8b7355; margin: 0;">🚚 Apakah ada pengiriman?</h4>
                        <i class="fas fa-chevron-down" id="icon-2"></i>
                    </div>
                    <p id="answer-2" style="color: #7a6852; margin: 0.5rem 0 0 0; display: none;">
                        YA! Biaya pengiriman untuk wilayah Balikpapan Tengah sebesar Rp12.000. Untuk wilayah di luar Balikpapan Tengah dikenakan biaya pengiriman sebesar Rp17.000.
                    </p>
                </div>

                <div class="faq-item" style="margin-bottom: 1rem; border-bottom: 1px solid #e8dfca; padding-bottom: 1rem;">
                    <div style="display: flex; justify-content: between; align-items: center; cursor: pointer;" onclick="toggleFAQ(3)">
                        <h4 style="color: #8b7355; margin: 0;">🎂 Bisa pesan custom design?</h4>
                        <i class="fas fa-chevron-down" id="icon-3"></i>
                    </div>
                    <p id="answer-3" style="color: #7a6852; margin: 0.5rem 0 0 0; display: none;">
                        Tentu! Kami spesialis kue custom. Untuk desain kue, silakan konfirmasi melalui WhatsApp. Kirimkan referensi atau inspirasi kue, kami siap membuatkannya sesuai keinginan Anda.
                    </p>
                </div>

                <div class="faq-item" style="margin-bottom: 1rem;">
                    <div style="display: flex; justify-content: between; align-items: center; cursor: pointer;" onclick="toggleFAQ(4)">
                        <h4 style="color: #8b7355; margin: 0;">💳 Metode pembayaran apa saja?</h4>
                        <i class="fas fa-chevron-down" id="icon-4"></i>
                    </div>
                    <p id="answer-4" style="color: #7a6852; margin: 0.5rem 0 0 0; display: none;">
                        Metode pembayaran hanya tersedia melalui QRIS. Silakan lakukan pembayaran dengan scan QRIS saat proses checkout.
                    </p>
                </div>
            </div>

            <!-- Quick Template Questions -->
            <h3 style="color: #8b7355; margin: 2rem 0 1rem 0;">Template Pertanyaan Cepat</h3>
            <div style="background: #f8f4e9; padding: 1.5rem; border-radius: 10px; border: 1px solid #e8dfca;">
                <p style="color: #7a6852; margin-bottom: 1rem;">Pilih template untuk mengisi form secara otomatis:</p>
                
                <div style="display: flex; flex-direction: column; gap: 0.5rem;">
                    <button class="template-btn" onclick="fillTemplate('konsultasi')" style="background: #e8dfca; border: 1px solid #d4c9b8; padding: 0.8rem; border-radius: 5px; color: #8b7355; cursor: pointer; text-align: left;">
                        💬 <strong>Konsultasi Kue Custom</strong><br>
                        <small>Saya ingin konsultasi untuk kue ulang tahun...</small>
                    </button>

                    <button class="template-btn" onclick="fillTemplate('pengiriman')" style="background: #e8dfca; border: 1px solid #d4c9b8; padding: 0.8rem; border-radius: 5px; color: #8b7355; cursor: pointer; text-align: left;">
                        🚚 <strong>Info Pengiriman & Biaya</strong><br>
                        <small>Saya mau tanya tentang pengiriman ke area...</small>
                    </button>

                    <button class="template-btn" onclick="fillTemplate('katalog')" style="background: #e8dfca; border: 1px solid #d4c9b8; padding: 0.8rem; border-radius: 5px; color: #8b7355; cursor: pointer; text-align: left;">
                        📋 <strong>Request Katalog Lengkap</strong><br>
                        <small>Bisa kirim katalog menu lengkapnya?</small>
                    </button>

                    <button class="template-btn" onclick="fillTemplate('komplain')" style="background: #e8dfca; border: 1px solid #d4c9b8; padding: 0.8rem; border-radius: 5px; color: #8b7355; cursor: pointer; text-align: left;">
                        ⚠️ <strong>Komplain / Keluhan</strong><br>
                        <small>Saya ada masalah dengan pesanan...</small>
                    </button>
                </div>
            </div>
        </div>

        <!-- Form Kontak -->
        <div>
            <h2 style="color: #8b7355; margin-bottom: 1.5rem;">Kirim Pesan</h2>
            <div style="background: #f8f4e9; padding: 2rem; border-radius: 10px; border: 1px solid #e8dfca;">
                <form id="contactForm">
                    <div style="margin-bottom: 1rem;">
                        <label style="display: block; margin-bottom: 0.5rem; color: #8b7355; font-weight: 600;">Nama Lengkap *</label>
                        <input type="text" id="nama" style="width: 100%; padding: 0.8rem; border: 2px solid #d4c9b8; border-radius: 5px; background: #fefbf6; color: #5c4b37;" required>
                    </div>

                    <div style="margin-bottom: 1rem;">
                        <label style="display: block; margin-bottom: 0.5rem; color: #8b7355; font-weight: 600;">Email *</label>
                        <input type="email" id="email" style="width: 100%; padding: 0.8rem; border: 2px solid #d4c9b8; border-radius: 5px; background: #fefbf6; color: #5c4b37;" required>
                    </div>

                    <div style="margin-bottom: 1rem;">
                        <label style="display: block; margin-bottom: 0.5rem; color: #8b7355; font-weight: 600;">Nomor WhatsApp</label>
                        <input type="tel" id="whatsapp" style="width: 100%; padding: 0.8rem; border: 2px solid #d4c9b8; border-radius: 5px; background: #fefbf6; color: #5c4b37;" placeholder="Contoh: 081234567890">
                    </div>

                    <div style="margin-bottom: 1rem;">
                        <label style="display: block; margin-bottom: 0.5rem; color: #8b7355; font-weight: 600;">Kategori Pertanyaan *</label>
                        <select id="kategori" style="width: 100%; padding: 0.8rem; border: 2px solid #d4c9b8; border-radius: 5px; background: #fefbf6; color: #5c4b37;" required>
                            <option value="">-- Pilih Kategori --</option>
                            <option value="konsultasi">Konsultasi Kue Custom</option>
                            <option value="pengiriman">Info Pengiriman</option>
                            <option value="harga">Info Harga & Menu</option>
                            <option value="pemesanan">Cara Pemesanan</option>
                            <option value="komplain">Komplain / Keluhan</option>
                            <option value="lainnya">Lainnya</option>
                        </select>
                    </div>

                    <div style="margin-bottom: 1rem;">
                        <label style="display: block; margin-bottom: 0.5rem; color: #8b7355; font-weight: 600;">Subjek *</label>
                        <input type="text" id="subjek" style="width: 100%; padding: 0.8rem; border: 2px solid #d4c9b8; border-radius: 5px; background: #fefbf6; color: #5c4b37;" required>
                    </div>

                    <div style="margin-bottom: 1.5rem;">
                        <label style="display: block; margin-bottom: 0.5rem; color: #8b7355; font-weight: 600;">Pesan Detail *</label>
                        <textarea id="pesan" rows="6" style="width: 100%; padding: 0.8rem; border: 2px solid #d4c9b8; border-radius: 5px; background: #fefbf6; color: #5c4b37; resize: vertical;" required></textarea>
                    </div>

                    <button type="button" class="btn btn-primary" style="width: 100%;" onclick="kirimKeWA()">
                    <i class="fab fa-whatsapp"></i> Kirim Pesan
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
// FAQ Toggle Function
function toggleFAQ(number) {
    const answer = document.getElementById('answer-' + number);
    const icon = document.getElementById('icon-' + number);
    
    if (answer.style.display === 'none' || answer.style.display === '') {
        answer.style.display = 'block';
        icon.className = 'fas fa-chevron-up';
    } else {
        answer.style.display = 'none';
        icon.className = 'fas fa-chevron-down';
    }
}

// Template Questions
function fillTemplate(type) {
    const templates = {
        'konsultasi': {
            subjek: 'Konsultasi Kue Custom',
            pesan: 'Halo LimcyCake,\n\nSaya ingin berkonsultasi untuk membuat kue custom. Bisa tolong info:\n1. Budget yang diperlukan\n2. Waktu pengerjaan\n3. Proses konsultasi desain\n\nTerima kasih!'
        },
        'pengiriman': {
            subjek: 'Info Pengiriman & Biaya',
            pesan: 'Halo LimcyCake,\n\nSaya mau tanya tentang pengiriman:\n1. Area pengiriman mana saja?\n2. Biaya ongkos kirim berapa?\n3. Berapa lama sampai?\n\nMohon informasinya.'
        },
        'katalog': {
            subjek: 'Request Katalog Lengkap',
            pesan: 'Halo LimcyCake,\n\nBisa tolong kirim katalog menu lengkap dan harga terbaru? Saya tertarik untuk melihat berbagai pilihan kue yang tersedia.\n\nTerima kasih!'
        },
        'komplain': {
            subjek: 'Komplain / Keluhan',
            pesan: 'Halo LimcyCake,\n\nSaya ingin menyampaikan keluhan mengenai:\n[Deskripsikan masalah yang dialami]\n\nMohon penanganan dan solusinya.\n\nTerima kasih.'
        }
    };

    if (templates[type]) {
        document.getElementById('subjek').value = templates[type].subjek;
        document.getElementById('pesan').value = templates[type].pesan;
        document.getElementById('kategori').value = type;
        
        // Scroll to form
        document.getElementById('subjek').scrollIntoView({ behavior: 'smooth' });
    }
}

// Form Submission
document.getElementById('contactForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    // Get form values
    const nama = document.getElementById('nama').value;
    const email = document.getElementById('email').value;
    const whatsapp = document.getElementById('whatsapp').value;
    const kategori = document.getElementById('kategori').value;
    const subjek = document.getElementById('subjek').value;
    const pesan = document.getElementById('pesan').value;
    
    // Simulate form submission
    alert(`Terima kasih ${nama}! Pesan Anda telah dikirim.\n\nKami akan membalas melalui email ${email} dalam 1x24 jam.${whatsapp ? ` Atau melalui WhatsApp ${whatsapp} untuk respon lebih cepat.` : ''}`);
    
    // Reset form
    document.getElementById('contactForm').reset();
});
</script>
<script>
function kirimKeWA() {
    const nama = document.getElementById('nama').value;
    const email = document.getElementById('email').value;
    const whatsapp = document.getElementById('whatsapp').value;
    const kategori = document.getElementById('kategori').value;
    const subjek = document.getElementById('subjek').value;
    const pesan = document.getElementById('pesan').value;

    const text = `Halo LimcyCake 👋

Nama: ${nama}
Email: ${email}
No WA: ${whatsapp}
Kategori: ${kategori}
Subjek: ${subjek}

Pesan:
${pesan}`;

    window.open(
        `https://wa.me/6281528957059?text=${encodeURIComponent(text)}`,
        '_blank'
    );
}
</script>

<?php include __DIR__ . '/../includes/footer.php'; ?>