<?php
$bodyClass = 'inner-page';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

include __DIR__ . '/../includes/header.php';

$total_belanja = 0;
?>

<div class="container">

    <div class="text-center mt-2 mb-4">
        <h1 class="cart-title">Keranjang Belanja</h1>
    </div>

    <?php if (empty($_SESSION['cart'])): ?>

        <!-- KERANJANG KOSONG -->
        <div style="
            background:#f8f4e9;
            padding:3rem 2rem;
            border-radius:16px;
            border:1px solid #e8dfca;
            max-width:600px;
            margin:3rem auto;
            text-align:center;
        ">
            <h2 style="color:#8b7355;margin-bottom:1rem;">
                🛒 Keranjang Anda masih kosong
            </h2>
            <p style="margin-bottom:2rem;">
                Yuk, pilih bento cake favoritmu 🤍
            </p>

            <a href="produk.php"
               style="
                display:inline-block;
                background:#8b7355;
                color:#fff;
                padding:1rem 2.5rem;
                border-radius:30px;
                text-decoration:none;
                font-weight:600;
               ">
                Kembali ke Produk
            </a>
        </div>

    <?php else: ?>

    <!-- GRID NORMAL (JIKA ADA ISI) -->
    <div style="display: grid; grid-template-columns: 2fr 1fr; gap: 2rem;">

        <!-- LIST ITEM -->
        <div>
        <?php foreach ($_SESSION['cart'] as $cart_key => $item): 
            $subtotal = $item['harga'] * $item['jumlah'];
            $total_belanja += $subtotal;
        ?>
            <div style="background:#f8f4e9;padding:1.5rem;border-radius:10px;border:1px solid #e8dfca;margin-bottom:1rem;">
                <div style="display:grid;grid-template-columns:100px 1fr auto auto;gap:1rem;align-items:center;">

                    <div style="width:100px;height:80px;border-radius:5px;overflow:hidden;background:#e8dfca;">
                        <img src="<?= BASE_URL ?>/assets/images/<?= htmlspecialchars($item['gambar']); ?>" 
                        alt="<?= htmlspecialchars($item['nama']); ?>"
                        style="width:100%;height:100%;object-fit:cover;"
                        >

                    </div>

                    <div>
                        <h3 style="color:#8b7355;margin:0 0 .5rem 0;">
                            <?= htmlspecialchars($item['nama']); ?>
                        </h3>
                        <p style="margin:0;font-size:.9rem;">
                            Harga: Rp <?= number_format($item['harga'],0,',','.'); ?>
                        </p>
                        <p style="font-weight:bold;margin-top:.4rem;">
                            Subtotal: Rp <?= number_format($subtotal,0,',','.'); ?>
                        </p>
                    </div>

                    <div>
                        <form action="update_keranjang.php" method="POST">
                            <input type="hidden" name="cart_key" value="<?= $cart_key; ?>">
                            <input type="number" name="jumlah" min="1"
                                value="<?= $item['jumlah']; ?>"
                                onchange="this.form.submit()"
                                style="width:65px;padding:.5rem;border:2px solid #d4c9b8;border-radius:6px;">
                        </form>
                    </div>

                    <div>
                        <form action="hapus_keranjang.php" method="POST">
                            <input type="hidden" name="cart_key" value="<?= $cart_key; ?>">
                            <button type="submit"
                                style="background:#e8dfca;border:1px solid #d4c9b8;
                                       padding:.5rem 1rem;border-radius:6px;cursor:pointer;">
                                Hapus
                            </button>
                        </form>
                    </div>

                </div>
            </div>
        <?php endforeach; ?>
        </div>

        <!-- RINGKASAN -->
        <div>
            <div style="background:#f8f4e9;padding:1.5rem;border-radius:10px;border:1px solid #e8dfca;">
                <h3 style="margin-bottom:1rem;">Ringkasan</h3>

                <div style="display:flex;justify-content:space-between;">
                    <span>Subtotal</span>
                    <strong>Rp <?= number_format($total_belanja,0,',','.'); ?></strong>
                </div>

                <hr>

                <div style="display:flex;justify-content:space-between;font-size:1.2rem;">
                    <strong>Total</strong>
                    <strong>Rp <?= number_format($total_belanja,0,',','.'); ?></strong>
                </div>

                <div style="background:#f8f4e9;padding:1.5rem;border-radius:10px;border:1px solid #e8dfca;">
    <h3 style="margin-bottom:1rem;">Ringkasan</h3>

    <div style="display:flex;justify-content:space-between;">
        <span>Subtotal</span>
        <strong>Rp <?= number_format($total_belanja,0,',','.'); ?></strong>
    </div>

    <hr>

    <div style="display:flex;justify-content:space-between;font-size:1.2rem;">
        <strong>Total</strong>
        <strong>Rp <?= number_format($total_belanja,0,',','.'); ?></strong>
    </div>

    <!-- 🔙 BUTTON PESAN LAGI -->
    <a href="produk.php"
       style="display:block;margin-top:1.2rem;text-align:center;
              background:transparent;color:#8b7355;
              padding:0.9rem;border-radius:8px;
              border:2px solid #8b7355;
              text-decoration:none;font-weight:500;">
        + Pesan Produk Lain
    </a>

    <!-- ✅ CHECKOUT -->
    <a href="checkout.php"
       style="display:block;margin-top:0.8rem;text-align:center;
              background:#8b7355;color:#fff;
              padding:1rem;border-radius:8px;
              text-decoration:none;font-weight:600;">
        Checkout
    </a>
</div>
        </div>

    </div>
    <?php endif; ?>

</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>
