<?php
session_start();
$pageTitle = "Beranda";
include 'includes/header.php';
?>

<!-- Hero Section -->
<section class="hero-section bg-primary text-white py-5">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-6">
                <h1 class="display-4 fw-bold">Selamat Datang di Twin House Homestay</h1>
                <p class="lead">Penginapan nyaman dengan konsep rumah kembar yang memberikan pengalaman menginap tak terlupakan.</p>
                <a href="produk.php" class="btn btn-light btn-lg mt-3">Lihat Kamar Tersedia</a>
            </div>
            <div class="col-md-6">
                <img src="assets/images/hero-image.jpg" alt="Twin House Homestay" class="img-fluid rounded">
          z  </div>
        </div>
    </div>
</section>

<!-- Featured Rooms -->
<section class="featured-rooms py-5">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="section-title">Kamar Unggulan</h2>
                <p class="text-muted">Pilihan kamar terbaik untuk kenyamanan Anda</p>
            </div>
        </div>
        <div class="row">
            <?php
            // Contoh data kamar (dalam implementasi nyata, data diambil dari database)
            $featuredRooms = [
                [
                    'id' => 1,
                    'name' => 'Kamar Twin Deluxe',
                    'price' => 350000,
                    'image' => 'assets/images/room1.jpg',
                    'rating' => 4.8
                ],
                [
                    'id' => 2,
                    'name' => 'Keluarga Suite',
                    'price' => 550000,
                    'image' => 'assets/images/room2.jpg',
                    'rating' => 4.9
                ],
                [
                    'id' => 3,
                    'name' => 'Kamar Twin Standard',
                    'price' => 250000,
                    'image' => 'assets/images/room3.jpg',
                    'rating' => 4.5
                ]
            ];

            foreach ($featuredRooms as $room):
            ?>
            <div class="col-md-4 mb-4">
                <div class="card room-card h-100">
                    <img src="<?php echo $room['image']; ?>" class="card-img-top" alt="<?php echo $room['name']; ?>">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <h5 class="card-title"><?php echo $room['name']; ?></h5>
                            <span class="badge bg-warning text-dark">
                                <i class="fas fa-star"></i> <?php echo $room['rating']; ?>
                            </span>
                        </div>
                        <p class="card-text text-muted">Kamar nyaman dengan fasilitas lengkap untuk kenyamanan Anda.</p>
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="h5 text-primary mb-0"><?php echo formatRupiah($room['price']); ?>/malam</span>
                            <a href="detail_produk.php?id=<?php echo $room['id']; ?>" class="btn btn-primary">Lihat Detail</a>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Features Section -->
<section class="features-section bg-light py-5">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2>Mengapa Memilih Kami?</h2>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4 text-center mb-4">
                <div class="feature-icon mb-3">
                    <i class="fas fa-shield-alt fa-3x text-primary"></i>
                </div>
                <h4>Aman dan Nyaman</h4>
                <p class="text-muted">Lingkungan yang aman dan nyaman untuk keluarga Anda</p>
            </div>
            <div class="col-md-4 text-center mb-4">
                <div class="feature-icon mb-3">
                    <i class="fas fa-wifi fa-3x text-primary"></i>
                </div>
                <h4>WiFi Gratis</h4>
                <p class="text-muted">Akses internet cepat gratis di seluruh area homestay</p>
            </div>
            <div class="col-md-4 text-center mb-4">
                <div class="feature-icon mb-3">
                    <i class="fas fa-concierge-bell fa-3x text-primary"></i>
                </div>
                <h4>Layanan 24 Jam</h4>
                <p class="text-muted">Layanan resepsionis 24 jam untuk kebutuhan Anda</p>
            </div>
        </div>
    </div>
</section>

<!-- Testimonials -->
<section class="testimonials py-5">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2>Apa Kata Tamu Kami?</h2>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4 mb-4">
                <div class="card testimonial-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            <img src="assets/images/user1.jpg" alt="User" class="rounded-circle me-3" width="50">
                            <div>
                                <h5 class="mb-0">Budi Santoso</h5>
                                <div class="text-warning">
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                </div>
                            </div>
                        </div>
                        <p class="card-text">"Penginapan yang sangat nyaman, pelayanan memuaskan, dan lokasi strategis. Recommended!"</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="card testimonial-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            <img src="assets/images/user2.jpg" alt="User" class="rounded-circle me-3" width="50">
                            <div>
                                <h5 class="mb-0">Sari Dewi</h5>
                                <div class="text-warning">
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star-half-alt"></i>
                                </div>
                            </div>
                        </div>
                        <p class="card-text">"Kamar bersih, fasilitas lengkap, dan harga terjangkau. Pasti akan kembali lagi!"</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="card testimonial-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            <img src="assets/images/user3.jpg" alt="User" class="rounded-circle me-3" width="50">
                            <div>
                                <h5 class="mb-0">Ahmad Rizki</h5>
                                <div class="text-warning">
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                </div>
                            </div>
                        </div>
                        <p class="card-text">"Perfect untuk staycation keluarga. Anak-anak sangat senang dengan ruangannya."</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>