<?php
// navbar.php - Navigation bar untuk website LimcyCake Balikpapan
?>

<nav class="navbar">
    <div class="nav-container">
        <!-- Logo -->
        <div class="nav-logo">
            <a href="../index.php">
                <div class="logo-content">
                    <i class="fas fa-birthday-cake"></i>
                    <div class="logo-text">
                        <span class="logo-main">LimcyCake</span>
                        <span class="logo-sub">Balikpapan</span>
                    </div>
                </div>
            </a>
        </div>

        <!-- Mobile Menu Toggle -->
        <div class="nav-toggle" id="navToggle">
            <span></span>
            <span></span>
            <span></span>
        </div>

        <!-- Navigation Menu -->
        <div class="nav-menu" id="navMenu">
            <ul class="nav-links">
                <li class="nav-item">
                    <a href="../index.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : ''; ?>">
                        <i class="fas fa-home"></i>
                        <span>Home</span>
                    </a>
                </li>
                
                <li class="nav-item dropdown">
                    <a href="produk.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'produk.php' ? 'active' : ''; ?>">
                        <i class="fas fa-store"></i>
                        <span>Produk</span>
                        <i class="fas fa-chevron-down dropdown-arrow"></i>
                    </a>
                    <div class="dropdown-menu">
                        <?php
                        $pdo = connectDB();
                        $categories = $pdo->query("SELECT * FROM categories WHERE is_active = 1 LIMIT 6")->fetchAll(PDO::FETCH_ASSOC);
                        foreach ($categories as $category):
                        ?>
                        <a href="produk.php?category=<?php echo $category['id']; ?>" class="dropdown-item">
                            <i class="fas fa-chevron-right"></i>
                            <?php echo $category['name']; ?>
                        </a>
                        <?php endforeach; ?>
                        <a href="produk.php" class="dropdown-item view-all">
                            <i class="fas fa-th-large"></i>
                            Lihat Semua Produk
                        </a>
                    </div>
                </li>
                
                <li class="nav-item">
                    <a href="tentang.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'tentang.php' ? 'active' : ''; ?>">
                        <i class="fas fa-info-circle"></i>
                        <span>Tentang Kami</span>
                    </a>
                </li>
                
                <li class="nav-item">
                    <a href="kontak.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'kontak.php' ? 'active' : ''; ?>">
                        <i class="fas fa-envelope"></i>
                        <span>Kontak</span>
                    </a>
                </li>
            </ul>

            <!-- Search Bar -->
            <div class="nav-search">
                <form action="produk.php" method="GET" class="search-form">
                    <div class="search-box">
                        <input type="text" name="search" placeholder="Cari kue..." class="search-input">
                        <button type="submit" class="search-btn">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </form>
            </div>

            <!-- User Actions -->
            <div class="nav-actions">
                <!-- Cart -->
                <div class="nav-action-item cart-dropdown">
                    <a href="keranjang.php" class="action-link <?php echo basename($_SERVER['PHP_SELF']) == 'keranjang.php' ? 'active' : ''; ?>">
                        <i class="fas fa-shopping-cart"></i>
                        <span class="action-text">Keranjang</span>
                        <?php if (getCartCount() > 0): ?>
                            <span class="cart-count"><?php echo getCartCount(); ?></span>
                        <?php endif; ?>
                    </a>
                    
                    <!-- Mini Cart Dropdown -->
                    <div class="mini-cart">
                        <div class="mini-cart-header">
                            <h4>Keranjang Belanja</h4>
                            <span><?php echo getCartCount(); ?> item</span>
                        </div>
                        
                        <div class="mini-cart-items" id="miniCartItems">
                            <!-- Items will be loaded via JavaScript -->
                        </div>
                        
                        <div class="mini-cart-footer">
                            <a href="keranjang.php" class="btn btn-primary btn-block">Lihat Keranjang</a>
                        </div>
                    </div>
                </div>

                <!-- User Account -->
                <div class="nav-action-item user-dropdown">
                    <?php if (isset($_SESSION['user_id'])): ?>
                        <a href="#" class="action-link user-link">
                            <i class="fas fa-user"></i>
                            <span class="action-text"><?php echo $_SESSION['user_name']; ?></span>
                            <i class="fas fa-chevron-down dropdown-arrow"></i>
                        </a>
                        
                        <div class="user-menu">
                            <div class="user-info">
                                <div class="user-avatar">
                                    <i class="fas fa-user-circle"></i>
                                </div>
                                <div class="user-details">
                                    <strong><?php echo $_SESSION['user_name']; ?></strong>
                                    <span><?php echo $_SESSION['user_email']; ?></span>
                                </div>
                            </div>
                            
                            <div class="user-links">
                                <a href="profil.php" class="user-menu-item">
                                    <i class="fas fa-user-edit"></i>
                                    Edit Profil
                                </a>
                                <a href="pesanan-saya.php" class="user-menu-item">
                                    <i class="fas fa-clipboard-list"></i>
                                    Pesanan Saya
                                </a>
                                <?php if (isset($_SESSION['user_role']) && $_SESSION['user_role'] == 'admin'): ?>
                                    <a href="../admin/dashboard.php" class="user-menu-item">
                                        <i class="fas fa-tachometer-alt"></i>
                                        Admin Dashboard
                                    </a>
                                <?php endif; ?>
                                <div class="user-divider"></div>
                                <a href="../logout.php" class="user-menu-item logout">
                                    <i class="fas fa-sign-out-alt"></i>
                                    Logout
                                </a>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="auth-buttons">
                            <a href="../login.php" class="btn btn-outline btn-sm">Login</a>
                            <a href="../register.php" class="btn btn-primary btn-sm">Daftar</a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</nav>

<!-- Mobile Menu Overlay -->
<div class="mobile-overlay" id="mobileOverlay"></div>

<script>
// Mobile Menu Toggle
document.addEventListener('DOMContentLoaded', function() {
    const navToggle = document.getElementById('navToggle');
    const navMenu = document.getElementById('navMenu');
    const mobileOverlay = document.getElementById('mobileOverlay');
    
    // Toggle mobile menu
    navToggle.addEventListener('click', function() {
        navMenu.classList.toggle('active');
        mobileOverlay.classList.toggle('active');
        document.body.classList.toggle('no-scroll');
    });
    
    // Close mobile menu when clicking overlay
    mobileOverlay.addEventListener('click', function() {
        navMenu.classList.remove('active');
        mobileOverlay.classList.remove('active');
        document.body.classList.remove('no-scroll');
    });
    
    // Close dropdowns when clicking outside
    document.addEventListener('click', function(e) {
        if (!e.target.closest('.dropdown')) {
            closeAllDropdowns();
        }
    });
    
    // Load mini cart items
    loadMiniCart();
});

// Dropdown functionality
function toggleDropdown(element) {
    const dropdown = element.closest('.nav-item').querySelector('.dropdown-menu');
    const isActive = dropdown.classList.contains('active');
    
    // Close all other dropdowns
    closeAllDropdowns();
    
    // Toggle current dropdown if it wasn't active
    if (!isActive) {
        dropdown.classList.add('active');
        element.classList.add('active');
    }
}

function closeAllDropdowns() {
    document.querySelectorAll('.dropdown-menu').forEach(dropdown => {
        dropdown.classList.remove('active');
    });
    document.querySelectorAll('.nav-link').forEach(link => {
        link.classList.remove('active');
    });
}

// Load mini cart items via AJAX
function loadMiniCart() {
    fetch('../includes/get-mini-cart.php')
        .then(response => response.text())
        .then(data => {
            document.getElementById('miniCartItems').innerHTML = data;
        })
        .catch(error => {
            console.error('Error loading mini cart:', error);
        });
}

// Update cart count
function updateCartCount(count) {
    const cartCount = document.querySelector('.cart-count');
    if (cartCount) {
        cartCount.textContent = count;
    } else if (count > 0) {
        // Create cart count badge if it doesn't exist
        const cartLink = document.querySelector('.cart-dropdown .action-link');
        const countBadge = document.createElement('span');
        countBadge.className = 'cart-count';
        countBadge.textContent = count;
        cartLink.appendChild(countBadge);
    }
    
    // Update mini cart header
    const miniCartHeader = document.querySelector('.mini-cart-header span');
    if (miniCartHeader) {
        miniCartHeader.textContent = count + ' item';
    }
}

// Add to cart from anywhere
function addToCart(productId, quantity = 1) {
    fetch('../includes/cart-actions.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `action=add&product_id=${productId}&quantity=${quantity}`
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            updateCartCount(data.count);
            loadMiniCart();
            showNotification('Produk berhasil ditambahkan ke keranjang!', 'success');
        } else {
            showNotification(data.message || 'Gagal menambahkan produk', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showNotification('Terjadi kesalahan', 'error');
    });
}

// Notification system
function showNotification(message, type = 'info') {
    const notification = document.createElement('div');
    notification.className = `notification notification-${type}`;
    notification.innerHTML = `
        <div class="notification-content">
            <i class="fas fa-${type === 'success' ? 'check-circle' : type === 'error' ? 'exclamation-circle' : 'info-circle'}"></i>
            <span>${message}</span>
        </div>
        <button class="notification-close" onclick="this.parentElement.remove()">
            <i class="fas fa-times"></i>
        </button>
    `;
    
    document.body.appendChild(notification);
    
    // Auto remove after 5 seconds
    setTimeout(() => {
        if (notification.parentElement) {
            notification.remove();
        }
    }, 5000);
}

// Search functionality
function performSearch(query) {
    if (query.length > 2) {
        // You can implement live search suggestions here
        console.log('Searching for:', query);
    }
}

// Sticky navbar on scroll
window.addEventListener('scroll', function() {
    const navbar = document.querySelector('.navbar');
    if (window.scrollY > 100) {
        navbar.classList.add('scrolled');
    } else {
        navbar.classList.remove('scrolled');
    }
});
</script>

<style>
/* Navbar Styles */
.navbar {
    background: linear-gradient(135deg, #ff6b6b, #ee5a52);
    padding: 1rem 0;
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    z-index: 1000;
    transition: all 0.3s ease;
    box-shadow: 0 2px 20px rgba(0,0,0,0.1);
}

.navbar.scrolled {
    padding: 0.5rem 0;
    background: rgba(255, 107, 107, 0.95);
    backdrop-filter: blur(10px);
}

.nav-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 1rem;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

/* Logo */
.nav-logo a {
    text-decoration: none;
    color: white;
}

.logo-content {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.logo-content i {
    font-size: 2rem;
    color: #ffeaa7;
}

.logo-text {
    display: flex;
    flex-direction: column;
    line-height: 1;
}

.logo-main {
    font-size: 1.5rem;
    font-weight: 700;
    color: white;
}

.logo-sub {
    font-size: 0.8rem;
    font-weight: 500;
    color: #ffeaa7;
    opacity: 0.9;
}

/* Mobile Toggle */
.nav-toggle {
    display: none;
    flex-direction: column;
    cursor: pointer;
    padding: 0.5rem;
}

.nav-toggle span {
    width: 25px;
    height: 3px;
    background: white;
    margin: 2px 0;
    transition: 0.3s;
    border-radius: 2px;
}

/* Navigation Menu */
.nav-menu {
    display: flex;
    align-items: center;
    gap: 2rem;
    flex: 1;
    justify-content: space-between;
    margin-left: 2rem;
}

.nav-links {
    display: flex;
    list-style: none;
    gap: 1.5rem;
    margin: 0;
    padding: 0;
}

.nav-item {
    position: relative;
}

.nav-link {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: white;
    text-decoration: none;
    padding: 0.5rem 1rem;
    border-radius: 5px;
    transition: all 0.3s ease;
    font-weight: 500;
}

.nav-link:hover,
.nav-link.active {
    background: rgba(255, 255, 255, 0.1);
    color: #ffeaa7;
}

.nav-link i {
    font-size: 1rem;
}

.dropdown-arrow {
    font-size: 0.8rem;
    transition: transform 0.3s ease;
}

.nav-link.active .dropdown-arrow {
    transform: rotate(180deg);
}

/* Dropdown Menu */
.dropdown-menu {
    position: absolute;
    top: 100%;
    left: 0;
    background: white;
    min-width: 200px;
    border-radius: 10px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.2);
    opacity: 0;
    visibility: hidden;
    transform: translateY(-10px);
    transition: all 0.3s ease;
    z-index: 1000;
}

.dropdown-menu.active {
    opacity: 1;
    visibility: visible;
    transform: translateY(0);
}

.dropdown-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.8rem 1rem;
    color: #2d3436;
    text-decoration: none;
    border-bottom: 1px solid #f1f3f4;
    transition: all 0.3s ease;
}

.dropdown-item:hover {
    background: #f8f9fa;
    color: #ff6b6b;
    padding-left: 1.5rem;
}

.dropdown-item:last-child {
    border-bottom: none;
}

.dropdown-item.view-all {
    background: #f8f9fa;
    font-weight: 600;
    color: #ff6b6b;
}

.dropdown-item i {
    font-size: 0.8rem;
    color: #74b9ff;
}

/* Search Bar */
.nav-search {
    flex: 1;
    max-width: 400px;
    margin: 0 2rem;
}

.search-form {
    width: 100%;
}

.search-box {
    position: relative;
    width: 100%;
}

.search-input {
    width: 100%;
    padding: 0.8rem 1rem;
    padding-right: 3rem;
    border: none;
    border-radius: 25px;
    background: rgba(255, 255, 255, 0.9);
    font-size: 0.9rem;
    transition: all 0.3s ease;
}

.search-input:focus {
    outline: none;
    background: white;
    box-shadow: 0 0 0 2px rgba(255, 234, 167, 0.5);
}

.search-btn {
    position: absolute;
    right: 0.5rem;
    top: 50%;
    transform: translateY(-50%);
    background: #ff6b6b;
    border: none;
    width: 35px;
    height: 35px;
    border-radius: 50%;
    color: white;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
}

.search-btn:hover {
    background: #ee5a52;
    transform: translateY(-50%) scale(1.1);
}

/* Navigation Actions */
.nav-actions {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.nav-action-item {
    position: relative;
}

.action-link {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: white;
    text-decoration: none;
    padding: 0.5rem 1rem;
    border-radius: 5px;
    transition: all 0.3s ease;
    position: relative;
}

.action-link:hover {
    background: rgba(255, 255, 255, 0.1);
    color: #ffeaa7;
}

.action-text {
    font-weight: 500;
}

.cart-count {
    position: absolute;
    top: -5px;
    right: 5px;
    background: #ff3838;
    color: white;
    border-radius: 50%;
    width: 18px;
    height: 18px;
    font-size: 0.7rem;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
}

/* Mini Cart */
.mini-cart {
    position: absolute;
    top: 100%;
    right: 0;
    background: white;
    width: 320px;
    border-radius: 10px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.2);
    opacity: 0;
    visibility: hidden;
    transform: translateY(-10px);
    transition: all 0.3s ease;
    z-index: 1000;
}

.cart-dropdown:hover .mini-cart {
    opacity: 1;
    visibility: visible;
    transform: translateY(0);
}

.mini-cart-header {
    padding: 1rem;
    border-bottom: 1px solid #f1f3f4;
    display: flex;
    justify-content: between;
    align-items: center;
}

.mini-cart-header h4 {
    margin: 0;
    color: #2d3436;
}

.mini-cart-header span {
    color: #636e72;
    font-size: 0.9rem;
}

.mini-cart-items {
    max-height: 300px;
    overflow-y: auto;
    padding: 1rem;
}

.mini-cart-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 0.8rem 0;
    border-bottom: 1px solid #f1f3f4;
}

.mini-cart-item:last-child {
    border-bottom: none;
}

.mini-cart-item img {
    width: 50px;
    height: 50px;
    object-fit: cover;
    border-radius: 5px;
}

.mini-cart-item-details {
    flex: 1;
}

.mini-cart-item-name {
    font-weight: 600;
    color: #2d3436;
    margin-bottom: 0.3rem;
    font-size: 0.9rem;
}

.mini-cart-item-price {
    color: #ff6b6b;
    font-weight: 600;
    font-size: 0.9rem;
}

.mini-cart-item-quantity {
    color: #636e72;
    font-size: 0.8rem;
}

.mini-cart-footer {
    padding: 1rem;
    border-top: 1px solid #f1f3f4;
}

.empty-cart-message {
    text-align: center;
    padding: 2rem 1rem;
    color: #636e72;
}

.empty-cart-message i {
    font-size: 2rem;
    margin-bottom: 1rem;
    color: #dee2e6;
}

/* User Dropdown */
.user-menu {
    position: absolute;
    top: 100%;
    right: 0;
    background: white;
    width: 280px;
    border-radius: 10px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.2);
    opacity: 0;
    visibility: hidden;
    transform: translateY(-10px);
    transition: all 0.3s ease;
    z-index: 1000;
}

.user-dropdown:hover .user-menu {
    opacity: 1;
    visibility: visible;
    transform: translateY(0);
}

.user-info {
    padding: 1.5rem;
    border-bottom: 1px solid #f1f3f4;
    display: flex;
    align-items: center;
    gap: 1rem;
}

.user-avatar i {
    font-size: 3rem;
    color: #74b9ff;
}

.user-details {
    flex: 1;
}

.user-details strong {
    display: block;
    color: #2d3436;
    margin-bottom: 0.3rem;
}

.user-details span {
    color: #636e72;
    font-size: 0.9rem;
}

.user-links {
    padding: 0.5rem 0;
}

.user-menu-item {
    display: flex;
    align-items: center;
    gap: 0.8rem;
    padding: 0.8rem 1.5rem;
    color: #2d3436;
    text-decoration: none;
    transition: all 0.3s ease;
}

.user-menu-item:hover {
    background: #f8f9fa;
    color: #ff6b6b;
    padding-left: 2rem;
}

.user-menu-item i {
    width: 20px;
    text-align: center;
    color: #74b9ff;
}

.user-menu-item.logout {
    color: #e17055;
}

.user-menu-item.logout i {
    color: #e17055;
}

.user-divider {
    height: 1px;
    background: #f1f3f4;
    margin: 0.5rem 0;
}

/* Auth Buttons */
.auth-buttons {
    display: flex;
    gap: 0.5rem;
}

/* Notifications */
.notification {
    position: fixed;
    top: 20px;
    right: 20px;
    background: white;
    padding: 1rem 1.5rem;
    border-radius: 10px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.2);
    display: flex;
    align-items: center;
    gap: 1rem;
    z-index: 9999;
    max-width: 400px;
    animation: slideInRight 0.3s ease;
}

.notification-success {
    border-left: 4px solid #00b894;
}

.notification-error {
    border-left: 4px solid #d63031;
}

.notification-info {
    border-left: 4px solid #74b9ff;
}

.notification-content {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    flex: 1;
}

.notification-content i {
    font-size: 1.2rem;
}

.notification-success .notification-content i {
    color: #00b894;
}

.notification-error .notification-content i {
    color: #d63031;
}

.notification-info .notification-content i {
    color: #74b9ff;
}

.notification-close {
    background: none;
    border: none;
    color: #636e72;
    cursor: pointer;
    padding: 0.3rem;
    border-radius: 3px;
    transition: all 0.3s ease;
}

.notification-close:hover {
    background: #f1f3f4;
    color: #2d3436;
}

/* Mobile Overlay */
.mobile-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0,0,0,0.5);
    z-index: 999;
    opacity: 0;
    visibility: hidden;
    transition: all 0.3s ease;
}

.mobile-overlay.active {
    opacity: 1;
    visibility: visible;
}

/* No Scroll */
body.no-scroll {
    overflow: hidden;
}

/* Animations */
@keyframes slideInRight {
    from {
        transform: translateX(100%);
        opacity: 0;
    }
    to {
        transform: translateX(0);
        opacity: 1;
    }
}

/* Responsive Design */
@media (max-width: 768px) {
    .nav-toggle {
        display: flex;
    }
    
    .nav-menu {
        position: fixed;
        top: 0;
        right: -100%;
        width: 300px;
        height: 100vh;
        background: white;
        flex-direction: column;
        align-items: stretch;
        padding: 2rem;
        transition: right 0.3s ease;
        margin-left: 0;
        overflow-y: auto;
    }
    
    .nav-menu.active {
        right: 0;
    }
    
    .nav-links {
        flex-direction: column;
        gap: 0;
    }
    
    .nav-link {
        color: #2d3436;
        padding: 1rem;
        border-radius: 5px;
        margin-bottom: 0.5rem;
    }
    
    .nav-link.active {
        background: #ff6b6b;
        color: white;
    }
    
    .dropdown-menu {
        position: static;
        box-shadow: none;
        background: #f8f9fa;
        margin-top: 0.5rem;
        margin-left: 1rem;
    }
    
    .nav-search {
        margin: 1rem 0;
        max-width: none;
    }
    
    .nav-actions {
        flex-direction: column;
        width: 100%;
        gap: 0.5rem;
    }
    
    .action-link {
        color: #2d3436;
        justify-content: space-between;
    }
    
    .auth-buttons {
        width: 100%;
    }
    
    .auth-buttons .btn {
        flex: 1;
        text-align: center;
    }
    
    .mini-cart,
    .user-menu {
        position: fixed;
        top: 0;
        right: -100%;
        width: 100%;
        height: 100vh;
        border-radius: 0;
        transition: right 0.3s ease;
    }
    
    .cart-dropdown:hover .mini-cart,
    .user-dropdown:hover .user-menu {
        right: 0;
    }
}

@media (max-width: 480px) {
    .nav-container {
        padding: 0 0.5rem;
    }
    
    .logo-main {
        font-size: 1.2rem;
    }
    
    .logo-sub {
        font-size: 0.7rem;
    }
    
    .nav-menu {
        width: 100%;
    }
}
</style>