<?php
// includes/functions.php

if (!function_exists('formatRupiah')) {
    function formatRupiah($angka) {
        return "Rp " . number_format($angka, 0, ',', '.');
    }
}

if (!function_exists('getCartCount')) {
    function getCartCount() {
        require_once __DIR__ . '/database.php';
        
        // Pastikan session jalan
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }

        if (!isset($_SESSION['cart_session'])) return 0;
        
        try {
            $pdo = connectDB();
            $stmt = $pdo->prepare("SELECT SUM(quantity) as total FROM cart WHERE session_id = ?");
            $stmt->execute([$_SESSION['cart_session']]);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            return $result['total'] ?? 0;
        } catch (Exception $e) {
            return 0;
        }
    }
}
?>