<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

require_once __DIR__ . '/../includes/database.php';
$pdo = connectDB();

/* UPDATE STATUS */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['order_id'])) {
    $stmt = $pdo->prepare("UPDATE orders SET status = ? WHERE id = ?");
    $stmt->execute([$_POST['status'], $_POST['order_id']]);
}

/* ambil semua order */
$stmt = $pdo->query("
    SELECT 
        id,
        nama_pelanggan,
        no_wa,
        total,
        status,
        tanggal_pesan,
        tanggal_ambil
    FROM orders
    ORDER BY id DESC
");
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Transaksi - Admin</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

<style>
body{
    margin:0;
    min-height:100vh;
    font-family:'Poppins',sans-serif;
    display:flex;
    justify-content:center;
    align-items:center;
    background:
        linear-gradient(rgba(248,244,233,.9),rgba(248,244,233,.9)),
        url('/limcycake_balikpapan/assets/images/bgadmin.jpeg');
    background-size:cover;
    background-position:center;
}

.admin-box{
    width:95%;
    max-width:1100px;
    background:#fff;
    padding:2.5rem;
    border-radius:18px;
    border:2px solid #e8dfca;
    box-shadow:0 20px 40px rgba(0,0,0,.15);
}

h2{
    margin-top:0;
    text-align:center;
    color:#a9926d;
}

.top-bar{
    display:flex;
    justify-content:space-between;
    margin-bottom:1.5rem;
}

.top-bar a{
    padding:.6rem 1.4rem;
    background:#a9926d;
    color:#fff;
    text-decoration:none;
    border-radius:20px;
    font-size:.85rem;
}

table{
    width:100%;
    border-collapse:collapse;
}

th,td{
    padding:.8rem;
    text-align:center;
    font-size:.85rem;
    border-bottom:1px solid #eee;
    vertical-align:top;
}

th{
    background:#f2ede1;
    color:#a9926d;
}

select{
    padding:.35rem .6rem;
    border-radius:12px;
    border:1px solid #d8ccb6;
    font-size:.75rem;
}

.wa{
    background:#25D366;
    color:#fff;
    padding:.4rem .9rem;
    border-radius:16px;
    text-decoration:none;
    font-size:.75rem;
}

.footer-link{
    margin-top:1.5rem;
    text-align:center;
}

.footer-link a{
    color:#a9926d;
    font-size:.85rem;
    text-decoration:none;
}
</style>
</head>
<body>

<div class="admin-box">
<h2>Daftar Pesanan Masuk</h2>

<div class="top-bar">
    <a href="dashboard_admin.php">← Dashboard</a>
</div>

<table>
<thead>
<tr>
    <th>ID</th>
    <th>Nama</th>
    <th>No WA</th>
    <th>Pesanan</th>
    <th>Total</th>
    <th>Tgl Pesan</th>
    <th>Tgl Ambil</th>
    <th>Status</th>
    <th>Chat</th>
</tr>
</thead>
<tbody>

<?php foreach($orders as $o): ?>
<tr>
<td><?= $o['id'] ?></td>
<td><?= htmlspecialchars($o['nama_pelanggan']) ?></td>
<td><?= htmlspecialchars($o['no_wa']) ?></td>

<td style="text-align:left">
<?php
$q = $pdo->prepare("
    SELECT p.nama_produk, oi.quantity
    FROM order_items oi
    JOIN products p ON p.id = oi.product_id
    WHERE oi.order_id = ?
");
$q->execute([$o['id']]);
foreach($q->fetchAll(PDO::FETCH_ASSOC) as $it){
    echo htmlspecialchars($it['nama_produk'])." ({$it['quantity']}x)<br>";
}
?>
</td>

<td>Rp <?= number_format($o['total'],0,',','.') ?></td>
<td><?= date('d-m-Y', strtotime($o['tanggal_pesan'])) ?></td>
<td><?= date('d-m-Y', strtotime($o['tanggal_ambil'])) ?></td>

<td>
<form method="POST">
<input type="hidden" name="order_id" value="<?= $o['id'] ?>">
<select name="status" onchange="this.form.submit()">
    <?php
    $statusList = ['pending','diproses','dikirim','selesai'];
    foreach($statusList as $s){
        $sel = $o['status']===$s?'selected':'';
        echo "<option value='$s' $sel>".ucfirst($s)."</option>";
    }
    ?>
</select>
</form>
</td>

<td>
<a class="wa" target="_blank"
   href="https://wa.me/62<?= ltrim($o['no_wa'],'0') ?>">
   WhatsApp
</a>
</td>
</tr>
<?php endforeach; ?>

</tbody>
</table>

<div class="footer-link">
    <a href="logout.php">Logout</a>
</div>
</div>

</body>
</html>
