<?php
session_start();

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

require_once __DIR__ . '/../includes/database.php';
$pdo = connectDB();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nama   = $_POST['nama_produk'];
    $harga  = $_POST['harga'];
    $stok   = $_POST['stok'];

    $stmt = $pdo->prepare(
        "INSERT INTO products (nama_produk, harga, stok) VALUES (?, ?, ?)"
    );
    $stmt->execute([$nama, $harga, $stok]);

    header("Location: produk_admin.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Tambah Produk - Admin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <style>
        body {
            margin: 0;
            min-height: 100vh;
            font-family: 'Poppins', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            background:
                linear-gradient(
                    rgba(248, 244, 233, 0.9),
                    rgba(248, 244, 233, 0.9)
                ),
                url('/limcycake_balikpapan/assets/images/bgadmin.jpeg');
            background-size: cover;
            background-position: center;
        }

        .form-card {
            width: 90%;
            max-width: 420px;
            background: white;
            padding: 2.5rem;
            border-radius: 18px;
            border: 2px solid #e8dfca;
            box-shadow: 0 20px 40px rgba(0,0,0,0.15);
        }

        h2 {
            margin-top: 0;
            text-align: center;
            color: #a9926d;
            font-weight: 600;
        }

        label {
            font-size: 0.85rem;
            color: #555;
        }

        input {
            width: 100%;
            padding: 0.7rem;
            margin: 0.4rem 0 1.2rem;
            border-radius: 8px;
            border: 1px solid #ccc;
            font-family: 'Poppins', sans-serif;
            font-size: 0.85rem;
        }

        .btn-group {
            display: flex;
            gap: 0.6rem;
            margin-top: 0.8rem;
        }

        button {
            flex: 1;
            padding: 0.7rem;
            border: none;
            border-radius: 20px;
            background: #a9926d;
            color: white;
            font-size: 0.85rem;
            cursor: pointer;
            transition: 0.3s;
        }

        button:hover {
            background: #98855f;
        }

        .back {
            flex: 1;
            text-align: center;
            padding: 0.7rem;
            border-radius: 20px;
            border: 1.5px solid #a9926d;
            color: #a9926d;
            text-decoration: none;
            font-size: 0.85rem;
        }

        .back:hover {
            background: #f2ede1;
        }
    </style>
</head>
<body>

<div class="form-card">
    <h2>Tambah Produk</h2>

    <form method="POST">
        <label>Nama Produk</label>
        <input type="text" name="nama_produk" required>

        <label>Harga</label>
        <input type="number" name="harga" required>

        <label>Stok</label>
        <input type="number" name="stok" required>

        <div class="btn-group">
            <button type="submit">Simpan</button>
            <a href="produk_admin.php" class="back">Batal</a>
        </div>
    </form>
</div>

</body>
</html>
